"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderResponseDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const order_entity_1 = require("../../../entities/order.entity");
class OrderItemResponseDto {
    id;
    productName;
    productImage;
    quantity;
    unitPrice;
    totalPrice;
    productId;
}
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'Order item ID' }),
    __metadata("design:type", Number)
], OrderItemResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Product Name', description: 'Product name' }),
    __metadata("design:type", String)
], OrderItemResponseDto.prototype, "productName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'product.jpg', description: 'Product image', required: false }),
    __metadata("design:type", String)
], OrderItemResponseDto.prototype, "productImage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 2, description: 'Quantity' }),
    __metadata("design:type", Number)
], OrderItemResponseDto.prototype, "quantity", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 99.99, description: 'Unit price' }),
    __metadata("design:type", Number)
], OrderItemResponseDto.prototype, "unitPrice", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 199.98, description: 'Total price' }),
    __metadata("design:type", Number)
], OrderItemResponseDto.prototype, "totalPrice", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'Product ID' }),
    __metadata("design:type", Number)
], OrderItemResponseDto.prototype, "productId", void 0);
class OrderResponseDto {
    id;
    orderNumber;
    totalAmount;
    taxAmount;
    shippingCost;
    discountAmount;
    status;
    paymentStatus;
    paymentMethod;
    shippingAddress;
    billingAddress;
    customerNotes;
    adminNotes;
    customerId;
    items;
    createdAt;
    updatedAt;
    shippedAt;
    deliveredAt;
    cancelledAt;
}
exports.OrderResponseDto = OrderResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: '550e8400-e29b-41d4-a716-446655440000', description: 'Order ID' }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'ORD-2024-001', description: 'Order number' }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "orderNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 199.98, description: 'Total amount' }),
    __metadata("design:type", Number)
], OrderResponseDto.prototype, "totalAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 19.99, description: 'Tax amount' }),
    __metadata("design:type", Number)
], OrderResponseDto.prototype, "taxAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 9.99, description: 'Shipping cost' }),
    __metadata("design:type", Number)
], OrderResponseDto.prototype, "shippingCost", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 10.00, description: 'Discount amount' }),
    __metadata("design:type", Number)
], OrderResponseDto.prototype, "discountAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'pending', description: 'Order status', enum: order_entity_1.OrderStatus }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'paid', description: 'Payment status' }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "paymentStatus", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Credit Card', description: 'Payment method' }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "paymentMethod", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '123 Main St, City, Country', description: 'Shipping address' }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "shippingAddress", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '123 Main St, City, Country', description: 'Billing address', required: false }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "billingAddress", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Please deliver after 5 PM', description: 'Customer notes', required: false }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "customerNotes", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Handled by admin', description: 'Admin notes', required: false }),
    __metadata("design:type", String)
], OrderResponseDto.prototype, "adminNotes", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'Customer ID' }),
    __metadata("design:type", Number)
], OrderResponseDto.prototype, "customerId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [OrderItemResponseDto], description: 'Order items' }),
    __metadata("design:type", Array)
], OrderResponseDto.prototype, "items", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-01T00:00:00.000Z', description: 'Creation timestamp' }),
    __metadata("design:type", Date)
], OrderResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-01T00:00:00.000Z', description: 'Last update timestamp' }),
    __metadata("design:type", Date)
], OrderResponseDto.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-02T00:00:00.000Z', description: 'Shipped at', required: false }),
    __metadata("design:type", Date)
], OrderResponseDto.prototype, "shippedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-03T00:00:00.000Z', description: 'Delivered at', required: false }),
    __metadata("design:type", Date)
], OrderResponseDto.prototype, "deliveredAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '2024-01-01T00:00:00.000Z', description: 'Cancelled at', required: false }),
    __metadata("design:type", Date)
], OrderResponseDto.prototype, "cancelledAt", void 0);
//# sourceMappingURL=order-response.dto.js.map